function prices = Price_MC_EO_Strikes_func(Spath, disc, call, Kvec)

prices = zeros(length(Kvec), 1);
for k = 1:length(Kvec)
    K = Kvec(k);
    prices(k)  = Price_MC_EO_func(Spath, disc, call, K);
end
end

function price= Price_MC_EO_func(Spath, disc, call, K)
    M = size(Spath, 2) - 1;  % number of time steps 
    N_sim = size(Spath, 1);   % number of paths
    
    if call==0
        price=(1/N_sim)*sum(disc*max((K-Spath(:,M+1)),0));
    else
        price=(1/(N_sim))*sum(disc*max((Spath(:,M+1)-K),0));
    end
end
